package ru.yandex.queryParser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.util.Version;

public abstract class QueryParserFactory {
    public Version version() {
        return Version.LUCENE_40;
    }

    public QueryParser create(final String field, final Analyzer analyzer) {
        return create(version(), field, analyzer);
    }

    public abstract QueryParser create(Version version, String field,
        Analyzer analyzer);

    public QueryParser create(final String field, final QueryParser example) {
        return create(version(), field, example);
    }

    public QueryParser create(final Version version, final String field,
        final QueryParser example)
    {
        return copyConfig(example,
            create(version, field, example.getAnalyzer()));
    }

    public static QueryParser copyConfig(final QueryParser from,
        final QueryParser to)
    {
        to.setDefaultOperator(from.getDefaultOperator());
        to.setLowercaseExpandedTerms(from.getLowercaseExpandedTerms());
        to.setReplaceEExpandedTerms(from.getReplaceEExpandedTerms());
        to.setMultiTermRewriteMethod(from.getMultiTermRewriteMethod());
        to.setAllowLeadingWildcard(from.getAllowLeadingWildcard());
        to.setEnablePositionIncrements(
            from.getEnablePositionIncrements());
        to.setPhraseSlop(from.getPhraseSlop());
        to.setFuzzyMinSim(from.getFuzzyMinSim());
        to.setFuzzyPrefixLength(from.getFuzzyPrefixLength());
        to.setLocale(from.getLocale());
        to.setAnalyzeRangeTerms(from.getAnalyzeRangeTerms());
        to.setAutoGeneratePhraseQueries(
            from.getAutoGeneratePhraseQueries());
        return to;
    }
}

