package ru.yandex.queryParser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.util.Version;

import ru.yandex.msearch.Config;
import ru.yandex.msearch.config.DatabaseConfig;

public class YandexQueryParserFactory extends QueryParserFactory {
    private final DatabaseConfig config;

    public YandexQueryParserFactory(final DatabaseConfig config) {
        this.config = config;
    }

    @Override
    public QueryParser create(final Version version, final String field,
        final Analyzer analyzer)
    {
        return new YandexQueryParser(
            version,
            field,
            analyzer,
            config);
    }
}

