package ru.yandex.search;

import java.io.IOException;

import java.util.Set;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public abstract class FilterQuery extends Query {
    protected final Query in;

    public FilterQuery(final Query in) {
        this.in = in;
    }

    public abstract FilterQuery doClone(final Query query);

    @Override
    public void setBoost(final float b) {
        in.setBoost(b);
    }

    @Override
    public float getBoost() {
        return in.getBoost();
    }

    @Override
    public String toString(final String field) {
        return in.toString(field);
    }

    @Override
    public String toString() {
        return in.toString();
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher)
        throws IOException
    {
        return in.createWeight(searcher);
    }

    @Override
    public Weight weight(final IndexSearcher searcher) throws IOException {
        return in.weight(searcher);
    }

    @Override
    public Query rewrite(final IndexReader reader) throws IOException {
        final Query rewrote = in.rewrite(reader);
        if (rewrote != in) {
            return doClone(rewrote);
        } else {
            return this;
        }
    }

    @Override
    public void extractTerms(final Set<Term> terms) {
        in.extractTerms(terms);
    }

    @Override
    public Object clone() {
        return doClone((Query) in.clone());
    }

    @Override
    public int hashCode() {
        return in.hashCode();
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FilterQuery) {
            return in.equals(((FilterQuery) obj).in);
        }
        return false;
    }
}
