package ru.yandex.search;

import java.io.IOException;

import java.util.Set;

import org.apache.lucene.search.BooleanClause.Occur;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;

public class FilterScorer extends Scorer {
    protected final Scorer in;

    public FilterScorer(final Scorer in) {
        super(null);
        this.in = in;
    }

    @Override
    public void score(final Collector collector) throws IOException {
        in.score(collector);
    }

    @Override
    public void close() {
        in.close();
    }

    @Override
    public boolean score(
        final Collector collector,
        final int max,
        final int firstDocID)
        throws IOException
    {
        return in.score(collector, max, firstDocID);
    }

    @Override
    public float score() throws IOException {
        return in.score();
    }

    @Override
    public float freq() throws IOException {
        return in.freq();
    }

    @Override
    public void visitScorers(
        final ScorerVisitor<Query, Query, Scorer> visitor)
    {
        in.visitSubScorers(null, Occur.MUST/*must id default*/, visitor);
    }

    @Override
    public void visitSubScorers(
        final Query parent,
        final Occur relationship,
        final ScorerVisitor<Query, Query, Scorer> visitor)
    {
        in.visitSubScorers(parent, relationship, visitor);
    }

    @Override
    public int docID() {
        return in.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return in.nextDoc();
    }

    public int advance(int target) throws IOException {
        return in.advance(target);
    }
}
