package ru.yandex.search;

import java.io.IOException;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReader.AtomicReaderContext;
import org.apache.lucene.index.IndexReader.ReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class FilterWeight extends Weight {
    protected final Weight in;

    public FilterWeight(final Weight in) {
        this.in = in;
    }

    @Override
    public Explanation explain(
        final AtomicReaderContext context,
        final int doc)
        throws IOException
    {
        return in.explain(context, doc);
    }

    @Override
    public int docFreq() {
        return in.docFreq();
    }

    @Override
    public Query getQuery() {
        return in.getQuery();
    }

    @Override
    public float getValue() {
        return in.getValue();
    }

    @Override
    public void normalize(final float norm) {
        in.normalize(norm);
    }

    @Override
    public Scorer scorer(
        final AtomicReaderContext context,
        final ScorerContext scorerContext)
        throws IOException
    {
        return in.scorer(context, scorerContext);
    }

    @Override
    public float sumOfSquaredWeights() throws IOException {
        return in.sumOfSquaredWeights();
    }

    @Override
    public boolean scoresDocsOutOfOrder() {
        return in.scoresDocsOutOfOrder();
    }
}
