package ru.yandex.search;

import java.io.IOException;

import java.util.HashMap;

import org.apache.lucene.search.Scorer;

import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class LuceneWrappingScorer implements YandexScorer {
    public final Scorer scorer;
    private final HashMap<Integer, Float> scores;

    public LuceneWrappingScorer(final Scorer scorer) {
        this.scorer = scorer;
        this.scores = new HashMap<>();
    }

    @Override
    public void preprocess(final int docId) throws IOException {
        final float score = scorer.score();
        scores.put(docId, score);
    }

    @Override
    public void process(final int docId, final YaDoc3 doc) throws IOException {
        Float score = scores.remove(docId);
        if (score == null) {
            score = Float.valueOf(0);
        }
        doc.setField(
            LuceneWrappingScorerFactory.FIELD,
            new YaField.FloatYaField(score));
    }
}
