package ru.yandex.search;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader.AtomicReaderContext;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Version;

import ru.yandex.msearch.Config;

import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.queryParser.YandexQueryParser;

public class LuceneWrappingScorerFactory extends YandexScorerFactory {
    protected static final String FIELD = "#score";

    public LuceneWrappingScorerFactory(final DatabaseConfig config) {
        super(config);
    }

    @Override
    public QueryParser createParser(
        final Version version,
        final String field,
        final Analyzer analyzer)
    {
        return new YandexQueryParser(
            version,
            field,
            analyzer,
            config);
    }

    @Override
    public YandexScorer scorer(
        final AtomicReaderContext context,
        final Scorer scorer)
    {
        return new LuceneWrappingScorer(scorer);
    }

    @Override
    public Set<String> outFields() {
        return Collections.<String>singleton(FIELD);
    }

}
