package ru.yandex.search;

import java.lang.reflect.Array;

import java.util.HashMap;

public class ScoreStorage {
    private final HashMap<Integer, Object[]> docIdMap;
    private int scorerCount;
    private int cachedDocId = -1;
    private Object[] cachedValue;

    public ScoreStorage() {
        scorerCount = 0;
        docIdMap = new HashMap<>();
    }

    public int newScorerId() {
        return scorerCount++;
    }

    public boolean contains(final int docId) {
        return docIdMap.containsKey(docId);
    }

    public <T> T[] docScores(final Class<T> scoreClass, final int docId) {
        if (docId == cachedDocId) {
            return (T[]) cachedValue;
        }
        T[] docScores = (T[]) docIdMap.get(docId);
        if (docScores == null) {
            docScores = (T[]) Array.newInstance(scoreClass, scorerCount);
            docIdMap.put(docId, docScores);
        }
        cachedDocId = docId;
        cachedValue = docScores;
        return docScores;
    }

    public void removeDocId(final int docId) {
        docIdMap.remove(docId);
    }
}
