package ru.yandex.search;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader.AtomicReaderContext;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Version;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.Config;
import ru.yandex.msearch.collector.FieldsProducingFunction;

import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.queryParser.QueryParserFactory;

public abstract class YandexScorerFactory
    extends QueryParserFactory
    implements FieldsProducingFunction
{
    protected DatabaseConfig config;

    protected YandexScorerFactory(final DatabaseConfig config) {
        this.config = config;
    }

    public static YandexScorerFactory create(
        final String params,
        final DatabaseConfig config)
        throws BadRequestException
    {
        final YandexScorerFactory ret;
        if (params == null || params.length() == 0) {
            ret = new NullScorerFactory(config);
        } else {
            int sep = params.indexOf('(');
            final String name;
            if (sep == -1) {
                name = params;
            } else {
                name = params.substring(0, sep);
            }
            final String[] paramsArray;
            final String paramsString;
            if (sep != -1) {
                int closingBracket = params.lastIndexOf(')');
                if (closingBracket == -1) {
                    closingBracket = params.length();
                }
                paramsString =
                    params.substring(sep + 1, closingBracket);
                paramsArray = paramsString.split(",");
            } else {
                paramsArray = new String[0];
            }

            if (name.equalsIgnoreCase("lucene")) {
                ret = new LuceneWrappingScorerFactory(config);
            } else if (name.equalsIgnoreCase("perfield")) {
                ret = new PerFieldScorerFactory(config, paramsArray);
            } else if (name.equalsIgnoreCase("null")) {
                return new NullScorerFactory(config);
            } else {
                throw new BadRequestException("Unknown scorer type: " + name);
            }
        }
        return ret;
    }

    @Override
    public QueryParser create(
        final Version version,
        final String field,
        final Analyzer analyzer)
    {
        return createParser(version ,field, analyzer);
    }

    public abstract QueryParser createParser(
        final Version version,
        final String field,
        final Analyzer analyzer);

    public abstract YandexScorer scorer(
        final AtomicReaderContext context,
        final Scorer scorer);

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public abstract Set<String> outFields();

    @Override
    public Set<String> loadFields() {
        return Collections.<String>emptySet();
    }
}
