package ru.yandex.ps.search.field.impl;

import ru.yandex.ps.search.field.GlobalStoredField;
import ru.yandex.ps.search.field.PrefixedStoredField;
import ru.yandex.ps.search.field.SearchBackendField;
import ru.yandex.ps.search.field.StoredGlobalPrefixed;

public class BasicSearchBackendField
    implements SearchBackendField,
    StoredGlobalPrefixed,
    PrefixedStoredField,
    GlobalStoredField
{
    protected final String name;
    protected final String stored;
    protected final String prefixed;
    protected final String global;

    public BasicSearchBackendField(
        final String name,
        final String stored,
        final String prefixed,
        final String global)
    {
        this.name = name;
        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    @Override
    public String name() {
        return name;
    }

    public String stored() {
        return stored;
    }

    public String prefixed() {
        return prefixed;
    }

    public String global() {
        return global;
    }
}
