package ru.yandex.ps.search;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.FieldConfig;
import ru.yandex.msearch.config.DatabaseConfig;

public class BackendFieldsConfig {
    private final Map<String, FieldConfig> fields = new LinkedHashMap<>();
    private final Map<String, String> aliases = new LinkedHashMap<>();
    private final Set<String> rootAliasedFields = new LinkedHashSet<>();
    private final Map<String, List<FieldConfig>> fieldsWithAliases = new LinkedHashMap<>();

    public BackendFieldsConfig(final DatabaseConfig config) throws Exception {
        for (Map.Entry<String, FieldConfig> entry: config.fieldsConfig().fields().entrySet()) {
            String field = StringHelper.intern(entry.getKey());
            FieldConfig fieldConfig = entry.getValue();
            fields.put(field, fieldConfig);
        }

        for (Map.Entry<String, FieldConfig> field: fields.entrySet()) {
            String alias = field.getValue().indexAlias();
            if (alias != null) {
                aliases.put(alias, field.getKey());
            }
        }

        Map<String, FieldConfig> toResolve = new LinkedHashMap<>();
        for (Map.Entry<String, FieldConfig> entry: fields.entrySet()) {
            String alias = entry.getValue().indexAlias();
            if (alias == null && aliases.containsKey(entry.getKey())) {
                fieldsWithAliases.computeIfAbsent(entry.getKey(), (x)-> new LinkedList<>()).add(entry.getValue());
            } else {
                List<FieldConfig> list = new ArrayList<>();
                list.add(entry.getValue());
                while (alias != null) {
                    FieldConfig fieldConfig = fields.get(alias);
                    if (fieldConfig != null) {
                        list.add(fieldConfig);
                    } else {
                        throw new Exception("Alias not found " + alias);
                    }

                    alias = fieldConfig.indexAlias();
                }

                fieldsWithAliases.put(entry.getKey(), list);
            }
        }

        for (Map.Entry<String, FieldConfig> field: fields.entrySet()) {
            if (aliases.get(field.getKey()) == null
                && field.getValue().indexAlias() != null)
            {
                rootAliasedFields.add(field.getKey());
            }
        }
    }

    public Map<String, FieldConfig> fields() {
        return fields;
    }

    public Map<String, String> aliases() {
        return aliases;
    }

    public Set<String> rootAliasedFields() {
        return rootAliasedFields;
    }

    public Map<String, List<FieldConfig>> fieldsWithAliases() {
        return fieldsWithAliases;
    }
}
