package ru.yandex.search.document;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

import ru.yandex.io.NullWriter;
import ru.yandex.json.writer.JsonWriterBase;

public class JsonDocument implements Document {
    private final JsonWriterBase writer;
    private final DocumentFieldsFilter fieldsFilter;
    private final String fieldsFilterOptions;

    public JsonDocument(
        final JsonWriterBase writer,
        final DocumentFieldsFilter fieldsFilter,
        final String fieldsFilterOptions)
        throws IOException
    {
        this.writer = writer;
        this.fieldsFilter = fieldsFilter;
        this.fieldsFilterOptions = fieldsFilterOptions;
        writer.startObject();
    }

    @Override
    public void close() throws IOException {
        writer.endObject();
    }

    @Override
    public void addField(final String name, final long value)
        throws IOException
    {
        writer.key(name);
        writer.value(value);
    }

    @Override
    public void addField(final String name, final double value)
        throws IOException
    {
        writer.key(name);
        writer.value(value);
    }

    @Override
    public void addField(final String name, final boolean value)
        throws IOException
    {
        writer.key(name);
        writer.value(value);
    }

    @Override
    public void addField(final String name, final String value)
        throws IOException
    {
        if (fieldsFilter.fieldAllowed(name)) {
            String filteredValue = fieldsFilter.filterFieldValue(
                name,
                value,
                fieldsFilterOptions);
            writer.key(name);
            writer.value(filteredValue);
        }
    }

    @Override
    public void addField(final String name, final Throwable value)
        throws IOException
    {
        writer.key(name);
        writer.value(value);
    }

    @Override
    public Writer addField(final String name) throws IOException {
        if (fieldsFilter.fieldAllowed(name)) {
            writer.key(name);
            writer.startString();
            Writer stringWriter = new FilterWriter(writer) {
                @Override
                public void close() throws IOException {
                    writer.endString();
                }
            };
            return fieldsFilter.filterFieldValue(
                name,
                stringWriter,
                fieldsFilterOptions);
        } else {
            return NullWriter.INSTANCE;
        }
    }
}

