package ru.yandex.search.json;

import ru.yandex.json.parser.JsonException;

public class AddMessageBodyHandler extends BodyHandler {
    private final AddDocumentsCollector documentsCollector;

    public AddMessageBodyHandler(
        final HandlersManager manager,
        final AddDocumentsCollector documentsCollector)
    {
        super(manager, documentsCollector);
        this.documentsCollector = documentsCollector;
    }

    @Override
    public void key(final String key) throws JsonException {
        if (key.equals("FailOnDuplicateKey")) {
            manager.push(
                new FailOnDuplicateKeyHandler(manager, documentsCollector));
        } else {
            super.key(key);
        }
    }
}

