package ru.yandex.search.json;

import java.util.Map;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.fieldfunction.ConstantValueFieldFunction;
import ru.yandex.search.json.fieldfunction.FieldFunction;
import ru.yandex.search.json.fieldfunction.FieldFunctionBuilder;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;
import ru.yandex.search.json.fieldfunction.NullFieldFunction;

public class AttributeHandler extends DefaultHandler {
    private final Map<String, FieldFunction> document;
    private final Map<String, String> conditions;
    private final String name;
    private FieldFunctionBuilder builder;

    // CSOFF: ParameterNumber
    public AttributeHandler(
        final HandlersManager manager,
        final Map<String, FieldFunction> document,
        final String name,
        final Map<String, String> conditions)
    {
        super(manager);
        this.document = document;
        this.name = name;
        this.conditions = conditions;
        builder = null;
    }
    // CSON: ParameterNumber

    private void put(final String name, final FieldFunction value)
        throws JsonException
    {
        FieldFunction oldValue = document.put(name, value);
        if (oldValue != null) {
            throw new JsonException(
                "Field " + name
                + " already exists with value: " + oldValue
                + ", can't overwrite with value: " + value);
        }
    }

    @Override
    public void value(final String value) throws JsonException {
        put(name, new ConstantValueFieldFunction(value));
    }

    @Override
    public void value(final long value) throws JsonException {
        put(name, new ConstantValueFieldFunction(value));
    }

    @Override
    public void value(final double value) throws JsonException {
        put(name, new ConstantValueFieldFunction(value));
    }

    @Override
    public void value(final boolean value) throws JsonException {
        value(Boolean.toString(value));
    }

    @Override
    public void nullValue() throws JsonException {
        put(name, new NullFieldFunction());
    }

    @Override
    public void startObject() {
        builder = new FieldFunctionBuilder(name, conditions);
        manager.push(new FieldFunctionHandler(manager, name, builder));
    }

    @Override
    public void endObject() throws JsonException {
        if (builder == null) {
            super.endObject();
        } else {
            try {
                put(name, builder.build());
            } catch (FieldFunctionException e) {
                throw new JsonException(e);
            }
        }
    }
}

