package ru.yandex.search.json;

import ru.yandex.search.json.fieldfunction.FieldFunctionException;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public interface BiOperationFilter {
    default FunctionValue apply(long left, long right) throws FieldFunctionException {
        throw new FieldFunctionException(this + "(long, long) not implemented ");
    }

    default FunctionValue apply(double left, double right) throws FieldFunctionException {
        throw new FieldFunctionException(this + "(float, float) not implemented ");
    }

    default FunctionValue apply(String left, String right) throws FieldFunctionException {
        throw new FieldFunctionException(this + "(str, str) not implemented ");
    }

    default FunctionValue apply(boolean left, boolean right) throws FieldFunctionException {
        throw new FieldFunctionException(this + "(boolean, boolean) not implemented ");
    }

    default FunctionValue apply(FunctionValue left, FunctionValue right) throws FieldFunctionException {
        throw new FieldFunctionException(this + "(FunctionValue, FunctionValue) not implemented ");
    }
}
