package ru.yandex.search.json;

import ru.yandex.json.parser.ContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.dp.CommonIndexDocProcessorHandler;

public class BodyHandler extends ObjectHandler {
    public BodyHandler(
        final HandlersManager manager,
        final DocumentsCollector collector)
    {
        super(manager, collector);
    }

    @Override
    public void key(final String key) throws JsonException {
        ContentHandler handler;
        switch (key) {
            case "prefix":
                handler = new PrefixHandler(manager, collector);
                break;
            case "processor":
                handler =
                    new CommonIndexDocProcessorHandler(manager, collector);
                break;
            case "docs":
                handler = new DocsArrayHandler(manager, collector);
                break;
            case "conds":
                handler = new CondsMapHandler(manager, collector);
                break;
            default:
                throw new JsonException("Unexpected key '" + key + '\'');
        }
        manager.push(handler);
    }
}

