package ru.yandex.search.json;

import ru.yandex.json.parser.JsonException;

public class DefaultHandler extends KeyCollectingHandler {
    public DefaultHandler(final HandlersManager manager) {
        super(manager);
    }

    @Override
    public void key(final String key) throws JsonException {
        throw new JsonException("Unexpected key '" + key + '\'');
    }

    public void value(final String value) throws JsonException {
        throw new JsonException("Unexpected value '" + value + '\'');
    }

    // CSOFF: ParameterNumber
    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        if (eol) {
            value(manager.sc().appendLast(buf, off, len));
        } else {
            manager.sc().append(buf, off, len);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void endObjectEntry() throws JsonException {
        manager.pop();
    }
}

