package ru.yandex.search.json;

import java.util.Map;

import ru.yandex.search.json.fieldfunction.FieldFunction;

public class DocHandler extends KeyCollectingHandler {
    private final Map<String, FieldFunction> document;
    private final Map<String, String> conditions;

    public DocHandler(
        final HandlersManager manager,
        final Map<String, FieldFunction> document,
        final Map<String, String> conditions)
    {
        super(manager);
        this.document = document;
        this.conditions = conditions;
    }

    @Override
    public void key(final String key) {
        manager.push(new AttributeHandler(manager, document, key, conditions));
    }

    @Override
    public void endObject() {
        manager.pop();
    }
}

