package ru.yandex.search.json;

import java.text.ParseException;

import ru.yandex.json.parser.BadContentHandler;
import ru.yandex.json.parser.JsonException;

public class DocsHandler extends BadContentHandler {
    private final HandlersManager manager;
    private final DocumentsCollector collector;

    public DocsHandler(
        final HandlersManager manager,
        final DocumentsCollector collector)
    {
        this.manager = manager;
        this.collector = collector;
    }

    @Override
    public void startObject() throws JsonException {
        try {
            manager.push(
                new DocHandler(
                    manager,
                    collector.addDocument(),
                    collector.getConditions()));
        } catch (ParseException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public void endArray() {
        manager.pop();
    }
}

