package ru.yandex.search.json;

public class FailOnDuplicateKeyHandler extends DefaultHandler {
    private final AddDocumentsCollector collector;

    public FailOnDuplicateKeyHandler(
        final HandlersManager manager,
        final AddDocumentsCollector collector)
    {
        super(manager);
        this.collector = collector;
    }

    @Override
    public void value(final String value) {
        value(Boolean.parseBoolean(value));
    }

    @Override
    public void value(final boolean value) {
        collector.setFailOnDuplicateKey(value);
    }
}

