package ru.yandex.search.json;

import ru.yandex.json.parser.ContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.fieldfunction.FieldFunctionBuilder;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;

public class FieldFunctionHandler extends DefaultHandler {
    private final String fieldName;
    private final FieldFunctionBuilder builder;

    public FieldFunctionHandler(
        final HandlersManager manager,
        final String fieldName,
        final FieldFunctionBuilder builder)
    {
        super(manager);
        this.fieldName = fieldName;
        this.builder = builder;
    }

    @Override
    public void key(final String key) throws JsonException {
        ContentHandler handler;
        switch (key) {
            case "function":
                handler = new FunctionNameHandler(manager, builder);
                break;
            case "args":
                handler =
                    new FunctionArgsArrayHandler(manager, fieldName, builder);
                break;
            default:
                //simplify function naming (all keys are considered as function
                //names)
                try {
                    builder.setFunctionName(key);
                } catch (FieldFunctionException e) {
                    throw new JsonException(e);
                }
                handler =
                    new FunctionArgsArrayHandler(manager, fieldName, builder);
        }
        manager.push(handler);
    }

    @Override
    public void endObject() throws JsonException {
        // TODO: Do something with this
        manager.pop();
        manager.endObject();
    }
}

