package ru.yandex.search.json;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.fieldfunction.ConstantValueFieldFunction;
import ru.yandex.search.json.fieldfunction.FieldFunctionBuilder;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;
import ru.yandex.search.json.fieldfunction.NullFieldFunction;

public class FunctionArgHandler extends DefaultHandler {
    private final FieldFunctionBuilder builder;
    private final String fieldName;
    private FieldFunctionBuilder subBuilder;

    public FunctionArgHandler(
        final HandlersManager manager,
        final String fieldName,
        final FieldFunctionBuilder builder)
    {
        super(manager);
        this.fieldName = fieldName;
        this.builder = builder;
        subBuilder = null;
    }

    @Override
    public void startObject() {
        subBuilder = new FieldFunctionBuilder(fieldName, builder.conditions());
        manager.push(new FieldFunctionHandler(manager, fieldName, subBuilder));
    }

    @Override
    public void endObject() throws JsonException {
        try {
            builder.addArgument(subBuilder.build());
        } catch (FieldFunctionException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public void endArray() {
        manager.pop();
    }

    @Override
    public void value(final String value) {
        builder.addArgument(new ConstantValueFieldFunction(value));
    }

    @Override
    public void value(final long value) {
        builder.addArgument(new ConstantValueFieldFunction(value));
    }

    @Override
    public void value(final double value) {
        builder.addArgument(new ConstantValueFieldFunction(value));
    }

    @Override
    public void nullValue() {
        builder.addArgument(new NullFieldFunction());
    }
}

