package ru.yandex.search.json;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.fieldfunction.FieldFunctionBuilder;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;

public class FunctionNameHandler extends DefaultHandler {
    private final FieldFunctionBuilder builder;

    public FunctionNameHandler(
        final HandlersManager manager,
        final FieldFunctionBuilder builder)
    {
        super(manager);
        this.builder = builder;
    }

    @Override
    public void value(final String value) throws JsonException {
        try {
            builder.setFunctionName(value);
        } catch (FieldFunctionException e) {
            throw new JsonException(e);
        }
    }
}

