package ru.yandex.search.json;

import ru.yandex.json.parser.BadContentHandler;
import ru.yandex.json.parser.JsonException;

public abstract class KeyCollectingHandler extends BadContentHandler {
    protected final HandlersManager manager;
    private final StringBuilder key = new StringBuilder();

    protected KeyCollectingHandler(final HandlersManager manager) {
        this.manager = manager;
    }

    public abstract void key(final String key) throws JsonException;

    // CSOFF: ParameterNumber
    @Override
    public void key(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        key.append(buf, off, len);
        if (eol) {
            key(key.toString().intern());
            key.setLength(0);
        }
    }
    // CSON: ParameterNumber
}

