package ru.yandex.search.json;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.dp.IndexDocProcessorConfig;
import ru.yandex.search.json.fieldfunction.FieldFunction;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixParser;

public class MapCollector implements DocumentsCollector {
    private final List<Map<String, FieldFunction>> docs = new ArrayList<>();
    private final PrefixParser prefixParser;
    private Prefix prefix = null;
    private Map<String, String> conditions = null;
    private IndexDocProcessorConfig docProcessorConfig = null;

    public MapCollector(final PrefixParser prefixParser) {
        this.prefixParser = prefixParser;
    }

    @Override
    public void setPrefix(final Object prefix) throws ParseException {
        this.prefix = prefixParser.parse(prefix);
    }

    public Prefix getPrefix() {
        return prefix;
    }

    @Override
    public Map<String, FieldFunction> addDocument() throws ParseException {
        Map<String, FieldFunction> doc = new LinkedHashMap<>();
        docs.add(doc);
        return doc;
    }

    public List<Map<String, FieldFunction>> getDocuments() {
        return docs;
    }

    @Override
    public Map<String, String> addConditions() {
        if (conditions == null) {
            conditions = new HashMap<>();
        }
        return conditions;
    }

    @Override
    public Map<String, String> getConditions() {
        return conditions;
    }

    @Override
    public void docProcessor(final IndexDocProcessorConfig config) {
        this.docProcessorConfig = config;
    }

    @Override
    public IndexDocProcessorConfig docProcessor() {
        return docProcessorConfig;
    }
}

