package ru.yandex.search.json;

import java.text.ParseException;

import ru.yandex.json.parser.JsonException;

public class PrefixHandler extends DefaultHandler {
    private final DocumentsCollector collector;

    public PrefixHandler(
        final HandlersManager manager,
        final DocumentsCollector collector)
    {
        super(manager);
        this.collector = collector;
    }

    private void value(final Object value) throws JsonException {
        try {
            collector.setPrefix(value);
        } catch (ParseException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public void value(final String value) throws JsonException {
        value((Object) value);
    }

    @Override
    public void value(final long value) throws JsonException {
        value((Object) value);
    }
}

