package ru.yandex.search.json;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.json.parser.JsonException;

public class PreserveFieldHandler extends DefaultHandler {
    private final UpdateDocumentsCollector collector;
    private final Set<String> preserveFields;

    public PreserveFieldHandler(
        final HandlersManager manager,
        final UpdateDocumentsCollector collector)
    {
        super(manager);

        this.collector = collector;
        this.preserveFields = new HashSet<>();
    }

    @Override
    public void value(final String value) throws JsonException {
        preserveFields.add(value);
    }

    @Override
    public void endArray() throws JsonException {
        collector.preserveFields(preserveFields);
        manager.pop();
    }
}
