package ru.yandex.search.json;

import ru.yandex.json.parser.BadContentHandler;

public class SkipObjectHandler extends BadContentHandler {
    private final HandlersManager manager;

    public SkipObjectHandler(final HandlersManager manager) {
        this.manager = manager;
    }

    // CSOFF: ParameterNumber
    @Override
    public void key(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
    {
        if (eol) {
            manager.push(new SkipObjectEntryHandler(manager));
        }
    }
    // CSON: ParameterNumber

    @Override
    public void endObject() {
        manager.pop();
    }
}

