package ru.yandex.search.json;

import ru.yandex.json.parser.ContentHandler;
import ru.yandex.json.parser.JsonException;

public class UpdateMessageBodyHandler extends BodyHandler {
    @SuppressWarnings("HidingField")
    private final UpdateDocumentsCollector collector;

    public UpdateMessageBodyHandler(
        final HandlersManager manager,
        final UpdateDocumentsCollector collector)
    {
        super(manager, collector);
        this.collector = collector;
    }

    @Override
    public void key(final String key) throws JsonException {
        ContentHandler handler;
        switch (key) {
            case "query":
                handler = new QueryHandler(manager, collector);
                break;
            case "AddIfNotExists":
                handler = new AddIfNotExistsHandler(manager, collector);
                break;
            case "UpdateIfNotMatches":
                handler = new UpdateIfNotMatchesHandler(manager, collector);
                break;
            case "PreserveFields":
                handler = new PreserveFieldsArrayHandler(manager, collector);
                break;
            default:
                super.key(key);
                return;
        }

        manager.push(handler);
    }
}

