package ru.yandex.search.json.dp;

import java.util.Locale;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.DefaultHandler;
import ru.yandex.search.json.DocumentsCollector;
import ru.yandex.search.json.HandlersManager;

public class CommonIndexDocProcessorHandler extends DefaultHandler {
    private final DocumentsCollector collector;

    public CommonIndexDocProcessorHandler(
        final HandlersManager manager,
        final DocumentsCollector collector)
    {
        super(manager);

        this.collector = collector;
    }

    @Override
    public void startObject() throws JsonException {
    }

    @Override
    public void key(final String key) throws JsonException {
        IndexDocProcessorType idpType;
        try {
            idpType =
                IndexDocProcessorType.valueOf(key.toUpperCase(Locale.ENGLISH));
        } catch (IllegalArgumentException iae) {
            throw new JsonException("Cannnot find doc processor " + key);
        }

        IndexDocProcessorConfig config = idpType.factory();
        collector.docProcessor(config);
        manager.push(config.contentHandler(manager));
    }

    @Override
    public void endObjectEntry() throws JsonException {
        manager.pop();
    }

    @Override
    public void endObject() throws JsonException {
    }
}
