package ru.yandex.search.json.dp.join;

import java.util.Set;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.DefaultHandler;
import ru.yandex.search.json.HandlersManager;

public class GetFieldHandler extends DefaultHandler {
    private final Set<String> fieldsCollector;

    public GetFieldHandler(
        final HandlersManager manager,
        final Set<String> fieldsCollector)
    {
        super(manager);

        this.fieldsCollector = fieldsCollector;
    }

    @Override
    public void value(final String value) throws JsonException {
        fieldsCollector.add(value);
    }

    @Override
    public void endArray() throws JsonException {
        manager.pop();
    }
}
