package ru.yandex.search.json.dp.join;

import java.util.Set;

import ru.yandex.json.parser.ContentHandler;
import ru.yandex.search.json.HandlersManager;
import ru.yandex.search.json.dp.IndexDocProcessorConfig;
import ru.yandex.search.json.dp.IndexDocProcessorType;
import ru.yandex.search.json.fieldfunction.FieldFunction;

public class JoinDocProcessorConfig implements IndexDocProcessorConfig {
    private FieldFunction query;
    private Set<String> getFields;

    public FieldFunction query() {
        return query;
    }

    public JoinDocProcessorConfig query(final FieldFunction query) {
        this.query = query;
        return this;
    }

    public Set<String> getFields() {
        return getFields;
    }

    public JoinDocProcessorConfig getFields(final Set<String> getFields) {
        this.getFields = getFields;
        return this;
    }

    @Override
    public ContentHandler contentHandler(final HandlersManager manager) {
        return new JoinDocProcessorHandler(manager, this);
    }

    @Override
    public IndexDocProcessorType type() {
        return IndexDocProcessorType.PKJOIN;
    }
}
