package ru.yandex.search.json.dp.join;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.json.parser.ContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.DefaultHandler;
import ru.yandex.search.json.HandlersManager;

public class JoinDocProcessorHandler extends DefaultHandler {
    protected final JoinDocProcessorConfig factory;

    public JoinDocProcessorHandler(
        final HandlersManager manager,
        final JoinDocProcessorConfig factory)
    {
        super(manager);
        this.factory = factory;
    }

    @Override
    public void startObject() throws JsonException {
    }

    @Override
    public void endObject() {
    }

    @Override
    public void key(final String key) throws JsonException {
        ContentHandler handler;
        switch (key) {
            case "query":
                handler = new JoinQueryHandler(manager, factory);
                break;
            case "get":
                Set<String> fieldsCollector = new LinkedHashSet<>();
                factory.getFields(fieldsCollector);
                handler = new GetFieldsArrayHandler(manager, fieldsCollector);
                break;
            default:
                throw new JsonException("Unexpected key '" + key + '\'');
        }
        manager.push(handler);
    }
}
