package ru.yandex.search.json.dp.join;

import java.util.Collections;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.json.DefaultHandler;
import ru.yandex.search.json.FieldFunctionHandler;
import ru.yandex.search.json.HandlersManager;
import ru.yandex.search.json.fieldfunction.ConstantValueFieldFunction;
import ru.yandex.search.json.fieldfunction.FieldFunction;
import ru.yandex.search.json.fieldfunction.FieldFunctionBuilder;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;

public class JoinQueryHandler extends DefaultHandler {
    private static final String QUERY = "query";

    private final JoinDocProcessorConfig factory;
    private FieldFunctionBuilder builder;
    private String value;

    public JoinQueryHandler(
        final HandlersManager manager,
        final JoinDocProcessorConfig factory)
    {
        super(manager);
        this.factory = factory;
    }

    @Override
    public void value(final String value) throws JsonException {
        if (this.builder != null) {
            throw new JsonException(
                "Trying set imple query, but complex already present");
        }
        this.value = value;
    }

    @Override
    public void startObject() throws JsonException {
        builder =
            new FieldFunctionBuilder(
                QUERY,
                Collections.emptyMap());
        manager.push(
            new FieldFunctionHandler(manager, QUERY, builder));
    }

    @Override
    public void endObject() throws JsonException {
        FieldFunction function;
        if (builder != null) {
            try {
                function = builder.build();
            } catch (FieldFunctionException ffe) {
                throw new JsonException(ffe);
            }
        } else {
            function = new ConstantValueFieldFunction(value);
        }

        factory.query(function);
    }
}
