package ru.yandex.search.json.fieldfunction;

import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractMapFunction
    implements FieldFunction, FunctionConstructor
{
    public static final String KV_SEPARATOR = "\t";
    public static final String RECORD_SEPARATOR = "\n";

    @SuppressWarnings("unused")
    protected String updateMap(final String first, final String second)
        throws FieldFunctionException
    {
        Map<String, String> map = new LinkedHashMap<>();
        addToMap(map, first);
        addToMap(map, second);
        return mapToString(map);
    }

    public String mapToString(final Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry: map.entrySet()) {
            sb.append(entry.getKey());
            sb.append(KV_SEPARATOR);
            sb.append(entry.getValue());
            sb.append(RECORD_SEPARATOR);
        }

        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }

        return sb.toString();
    }

    protected void addToMap(
        final Map<String, String> map,
        final String first,
        final String second)
    {
        buildMap(map, first, second);
    }

    @SuppressWarnings("StringSplitter")
    public static void addToMap(
        final Map<String, String> map,
        final String stringValue)
    {
        for (String line: stringValue.split(RECORD_SEPARATOR)) {
            if (line.isEmpty()) {
                continue;
            }

            String first;
            String second;
            String[] kv = line.split(KV_SEPARATOR);
            if (kv.length != 2) {
                if (kv.length < 2) {
                    throw new NumberFormatException(
                        "SumMapFunciton: wrong format " + stringValue);
                } else {
                    first = kv[0];
                    second = line.substring(kv[0].length() + 1);
                }
            } else {
                first = kv[0];
                second = kv[1];
            }

            buildMap(map, first, second);
        }
    }

    protected static void buildMap(
        final Map<String, String> map,
        final String first,
        final String second)
    {
        map.put(first, second);
    }
}
