package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.BooleanValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class AndFunction implements FieldFunction, FunctionConstructor {
    private final List<FieldFunction> args;

    public AndFunction() {
        args = null;
    }

    public AndFunction(final List<FieldFunction> args) {
        this.args = args;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        boolean value =
            args.get(0).value(accessor, condAccessor).booleanValue();
        //fail fast
        if (value) {
            for (int i = 1; i < args.size(); i++) {
                value = value
                    && args.get(i).value(accessor, condAccessor).booleanValue();
                if (!value) {
                    //fail fast
                    break;
                }
            }
        }
        return BooleanValue.valueOf(value);
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() < 1) {
            throw new FieldFunctionException(
                "AndFunction: invalid argument count <"
                + args.size() + ">, but should be at least 1");
        }
        return new AndFunction(args);
    }

    @Override
    public String toString() {
        return "AndFunction( " + args + ')';
    }
}
