package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.IntValue;

public class AverageFunction implements FieldFunction, FunctionConstructor {
    private final String fieldName;
    private final FieldFunction counterName;
    private final FieldFunction addingValue;

    public AverageFunction() {
        fieldName = null;
        counterName = null;
        addingValue = null;
    }

    public AverageFunction(
        final String fieldName,
        final FieldFunction addingValue,
        final FieldFunction counterName)
    {
        this.fieldName = fieldName;
        this.addingValue = addingValue;
        this.counterName = counterName;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        FunctionValue currentFieldValue = accessor.getFieldValue(fieldName);
        FunctionValue counterFieldValue = accessor.getFieldValue(
            counterName.value(accessor, condAccessor).stringValue());

        long count = counterFieldValue.intValue();
        long avg = currentFieldValue.intValue();
        avg *= count;
        avg += addingValue.value(accessor, condAccessor).intValue();
        avg /= count + 1;
        return new IntValue(avg);
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != 2) {
            throw new FieldFunctionException(
                "AverageFunction: invalid argument count <"
                + args.size()
                + ">, but should be 2 (<new value>, <counter fieldname>)");
        }
        return new AverageFunction(fieldName, args.get(0), args.get(1));
    }

    @Override
    public String toString() {
        String desc = "AverageFunction( "
            + addingValue
            + ", " + counterName
            + ')';
        return desc;
    }
}
