package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;

import ru.yandex.function.GenericBiFunction;
import ru.yandex.search.json.BiOperationFilter;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.ValueType;

public class BiFieldFunction implements FieldFunction, FunctionConstructor {
    private final FieldFunction arg1;
    private final FieldFunction arg2;
    @Nonnull
    private final GenericBiFunction<FunctionValue, FunctionValue, FunctionValue, FieldFunctionException> op;

    public BiFieldFunction(@Nonnull BiOperationFilter op) {
        this(op, ValueType.INT);
    }

    public BiFieldFunction(@Nonnull BiOperationFilter op,
                           @Nonnull ValueType dtype) {
        this(dtype.apply(op), null, null);
    }

    public BiFieldFunction(@Nonnull GenericBiFunction<FunctionValue, FunctionValue, FunctionValue,
            FieldFunctionException> op,
                           final FieldFunction arg1,
                           final FieldFunction arg2) {
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.op = op;
    }

    @Override
    public final FunctionValue value(
            final FieldAccessor accessor,
            final ConditionsAccessor condAccessor)
            throws FieldFunctionException {
        return op.apply(arg1.value(accessor, condAccessor), arg2.value(accessor, condAccessor));
    }

    @Override
    public final FieldFunction construct(
            final String fieldName,
            final List<FieldFunction> args,
            final Map<String, String> conditions)
            throws FieldFunctionException {
        if (args.size() != 2) {
            throw new FieldFunctionException(
                    "SumFunction: invalid argument count <"
                            + args.size() + ">, but should be 2");
        }
        return new BiFieldFunction(op, args.get(0), args.get(1));
    }

    @Override
    public String toString() {
        return op + "( " + arg1 + ", " + arg2 + ')';
    }
}
