package ru.yandex.search.json.fieldfunction;


import ru.yandex.search.json.BiOperationFilter;
import ru.yandex.search.json.fieldfunction.value.BooleanValue;
import ru.yandex.search.json.fieldfunction.value.FloatValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.IntValue;

public enum BiOperationFabric implements BiOperationFilter {
    SUM {
        @Override
        public IntValue apply(long left, long right) {
            return new IntValue(left + right);
        }

        @Override
        public FloatValue apply(double left, double right) {
            return new FloatValue(left + right);
        }
    },
    MUL {
        @Override
        public IntValue apply(long left, long right) {
            return new IntValue(left * right);
        }

        @Override
        public FloatValue apply(double left, double right) {
            return new FloatValue(left * right);
        }
    },
    DIV {
        @Override
        public IntValue apply(long left, long right) {
            return new IntValue(left / right);
        }

        @Override
        public FloatValue apply(double left, double right) {
            return new FloatValue(left / right);
        }
    },
    SUB {
        @Override
        public IntValue apply(long left, long right) {
            return new IntValue(left - right);
        }

        @Override
        public FloatValue apply(double left, double right) {
            return new FloatValue(left - right);
        }
    },
    MAX {
        @Override
        public IntValue apply(long left, long right) {
            return new IntValue(Long.max(left, right));
        }

        @Override
        public FloatValue apply(double left, double right) {
            return new FloatValue(Double.max(left, right));
        }

        @Override
        public FunctionValue apply(FunctionValue left, FunctionValue right) {
            return left.compare(right) >= 0 ? left : right;
        }
    },
    MIN {
        @Override
        public IntValue apply(long left, long right) {
            return new IntValue(Long.min(left, right));
        }

        @Override
        public FloatValue apply(double left, double right) {
            return new FloatValue(Double.min(left, right));
        }

        @Override
        public FunctionValue apply(FunctionValue left, FunctionValue right) {
            return left.compare(right) <= 0 ? left : right;
        }
    },
    POW {
        @Override
        public IntValue apply(long base, long exponent) {
            return new IntValue((long) Math.pow(base, exponent));
        }

        @Override
        public FloatValue apply(double base, double exponent) {
            return new FloatValue(Math.pow(base, exponent));
        }
    },
    LT {
        @Override
        public BooleanValue apply(FunctionValue left, FunctionValue right) {
            return BooleanValue.valueOf(left.compare(right) < 0);
        }
    },
    LE {
        @Override
        public BooleanValue apply(FunctionValue left, FunctionValue right) {
            return BooleanValue.valueOf(left.compare(right) <= 0);
        }
    },
    GT {
        @Override
        public BooleanValue apply(FunctionValue left, FunctionValue right) {
            return BooleanValue.valueOf(left.compare(right) > 0);
        }
    },
    GE {
        @Override
        public BooleanValue apply(FunctionValue left, FunctionValue right) {
            return BooleanValue.valueOf(left.compare(right) >= 0);
        }
    },
    EQ {
        @Override
        public BooleanValue apply(FunctionValue left, FunctionValue right) {
            return BooleanValue.valueOf(left.equalsTo(right));
        }
    },
}
