package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class CaseFunction implements FieldFunction, FunctionConstructor {
    private final List<FieldFunction> args;

    public CaseFunction() {
        args = null;
    }

    public CaseFunction(final List<FieldFunction> args) {
        this.args = args;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        if (condAccessor == null) {
            throw new FieldFunctionException("ConditionsAccessor is null");
        }
        for (int i = 1; i < args.size(); i += 2) {
            FieldFunction cond = args.get(i);
            FieldFunction value = args.get(i + 1);
            if (condAccessor.getBoolean(
                cond.value(accessor, condAccessor).stringValue()))
            {
                return value.value(accessor, condAccessor);
            }
        }
        return args.get(0).value(accessor, condAccessor);
    }

    @Override
    public final FieldFunction construct(
        final String fielName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() < 1) {
            throw new FieldFunctionException(
                "CaseFunction: invalid argument count <"
                + args.size() + ">, but should be not less than 1");
        } else if (((args.size() - 1) % 2) != 0) {
            throw new FieldFunctionException(
                "CaseFunction: wrong argument count. "
                + "Should be an even number (ie 2 + 1) "
                + "but <" + args.size() + "> found");
        }
        for (int i = 1; i < args.size(); i += 2) {
            if (args.get(i) instanceof ConstantValueFieldFunction) {
                String value = args.get(i).value(null, null).stringValue();
                if (conditions.get(value) == null) {
                    throw new FieldFunctionException(
                        "CaseFunction: condition <" + value
                        + "> has not been defined");
                }
            }
        }
        return new CaseFunction(args);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CaseFunction( ");
        String comma = "";
        for (FieldFunction arg : args) {
            sb.append(comma);
            comma = ",";
            sb.append(arg);
        }
        sb.append(')');
        return sb.toString();
    }
}
