package ru.yandex.search.json.fieldfunction;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.StringValue;

public class ConcatFunction implements FieldFunction, FunctionConstructor {
    private final List<FieldFunction> args;

    public ConcatFunction() {
        args = Collections.emptyList();
    }

    public ConcatFunction(
        final List<FieldFunction> args)
    {
        this.args = args;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        StringBuilder result = new StringBuilder();
        for (FieldFunction arg: this.args) {
            result.append(arg.value(accessor, condAccessor).stringValue());
        }
        return new StringValue(result.toString());
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        return new ConcatFunction(args);
    }

    @Override
    public String toString() {
        return "ConcatFunction(" + args + ')';
    }
}

