package ru.yandex.search.json.fieldfunction;

import ru.yandex.search.json.fieldfunction.value.FloatValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.IntValue;
import ru.yandex.search.json.fieldfunction.value.StringValue;

public class ConstantValueFieldFunction implements FieldFunction {
    private final FunctionValue value;

    public ConstantValueFieldFunction(final String value) {
        this.value = new StringValue(value);
    }

    public ConstantValueFieldFunction(final long value) {
        this.value = new IntValue(value);
    }

    public ConstantValueFieldFunction(final double value) {
        this.value = new FloatValue(value);
    }

    @Override
    public FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
    {
        return value;
    }

    @Override
    public String toString() {
        return "ConstantValueFieldFunction(" + value + ')';
    }
}

