package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.IntValue;

public class DecrementFunction implements FieldFunction, FunctionConstructor {
    private static final long DEFAULT_DECREMENT = 1;

    private final FieldFunction decrement;
    private final String fieldName;

    public DecrementFunction() {
        decrement = null;
        fieldName = null;
    }

    public DecrementFunction(
        final String fieldName,
        final FieldFunction decrement)
    {
        this.fieldName = fieldName;
        this.decrement = decrement;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        FunctionValue fieldValue = accessor.getFieldValue(fieldName);
        if (decrement != null) {
            return new IntValue(
                fieldValue.intValue()
                - decrement.value(accessor, condAccessor).intValue());
        }
        return new IntValue(fieldValue.intValue() - DEFAULT_DECREMENT);
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() > 1) {
            throw new FieldFunctionException(
                "DecrementFunction: invalid argument count <"
                + args.size() + ">, but should be 1 or 0");
        }
        if (args.size() == 1) {
            return new DecrementFunction(fieldName, args.get(0));
        }
        return new DecrementFunction(fieldName, null);
    }

    @Override
    public String toString() {
        String desc = "DecrementFunction( ";
        if (decrement != null) {
            desc += decrement;
        } else {
            desc += DEFAULT_DECREMENT;
        }
        desc += ')';
        return desc;
    }
}
