package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.DefaultValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class DefaultFunction implements FieldFunction, FunctionConstructor {
    private final FieldFunction defaultValue;
    private final String fieldName;

    public DefaultFunction() {
        fieldName = null;
        defaultValue = null;
    }

    public DefaultFunction(
        final String fieldName,
        final FieldFunction defaultValue)
    {
        this.fieldName = fieldName;
        this.defaultValue = defaultValue;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        FunctionValue fieldValue = accessor.getFieldValue(fieldName);
        if (fieldValue == DefaultValue.INSTANCE) {
            fieldValue = defaultValue.value(accessor, condAccessor);
        }
        return fieldValue;
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        final int argsSize = args.size();
        final FieldFunction ret;
        switch (argsSize) {
            case 1:
                ret = new DefaultFunction(fieldName, args.get(0));
                break;
            default:
                throw new FieldFunctionException(
                    "DefaultFunction: invalid argument count <"
                    + argsSize + ">. Usage: default(defaultValue)");
        }
        return ret;
    }

    @Override
    public String toString() {
        String desc = "DefaultFunction( ";
        desc += defaultValue;
        desc += ')';
        return desc;
    }
}
