package ru.yandex.search.json.fieldfunction;

import java.util.ArrayList;
import java.util.Map;

public class FieldFunctionBuilder {
    private final String fieldName;
    private final Map<String, String> conditions;
    private String functionName = null;
    private ArrayList<FieldFunction> args = new ArrayList<FieldFunction>();

    public FieldFunctionBuilder(
        final String fieldName,
        final Map<String, String> conditions)
    {
        this.fieldName = fieldName;
        this.conditions = conditions;
    }

    public Map<String, String> conditions() {
        return conditions;
    }

    public void setFunctionName(final String functionName)
        throws FieldFunctionException
    {
        if (this.functionName != null) {
            throw new FieldFunctionException(
                "Field function name was already set to: " + this.functionName);
        }
        this.functionName = functionName;
    }

    public void addArgument(final FieldFunction argument) {
        args.add(argument);
    }

    public FieldFunction build() throws FieldFunctionException {
        return FieldFunctionFactory.create(
            functionName,
            fieldName,
            args,
            conditions);
    }
}
