package ru.yandex.search.json.fieldfunction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.ValueType;

public final class FieldFunctionFactory {
    private static final Map<String, FunctionConstructor> functions =
        initFunctionsMap();

    private FieldFunctionFactory() {
    }

    private static Map<String, FunctionConstructor> initFunctionsMap() {
        Map<String, FunctionConstructor> map = new HashMap<>();

        map.put("set", new SetFunction());
        map.put("get", new GetFunction());
        map.put("inc", new IncrementFunction());
        map.put("dec", new DecrementFunction());

        map.put("sum", new BiFieldFunction(BiOperationFabric.SUM));
        map.put("sumf", new BiFieldFunction(BiOperationFabric.SUM, ValueType.FLOAT));

        map.put("mul", new BiFieldFunction(BiOperationFabric.MUL));
        map.put("mulf", new BiFieldFunction(BiOperationFabric.MUL, ValueType.FLOAT));

        map.put("sub", new BiFieldFunction(BiOperationFabric.SUB));
        map.put("subf", new BiFieldFunction(BiOperationFabric.SUB, ValueType.FLOAT));

        map.put("div", new BiFieldFunction(BiOperationFabric.DIV));
        map.put("divf", new BiFieldFunction(BiOperationFabric.DIV, ValueType.FLOAT));

        map.put("pow", new BiFieldFunction(BiOperationFabric.POW));
        map.put("powf", new BiFieldFunction(BiOperationFabric.POW, ValueType.FLOAT));

        map.put("avg", new AverageFunction());
        map.put("case", new CaseFunction());

        map.put("max", new BiFieldFunction(BiOperationFabric.MAX));
        map.put("maxf", new BiFieldFunction(BiOperationFabric.MAX, ValueType.FLOAT));

        map.put("min", new BiFieldFunction(BiOperationFabric.MIN));
        map.put("minf", new BiFieldFunction(BiOperationFabric.MIN, ValueType.FLOAT));

        map.put("make_set", new MakeSetFunction());
        map.put("remove_set", new RemoveSetFunction());
        map.put("sum_map", new SumMapFunction());
        map.put("make_long_map", new MakeLongMapFunction());
        map.put("sum_queue", new SumQueueFunction());
        map.put("map_contains", new MapContainsAnyFunction());
        map.put("map_max", new MapMaxFunction());
        map.put("map_get", new MapGetFunction());
        map.put("map_set", new MapSetFunction());
        map.put("lt", new BiFieldFunction(BiOperationFabric.LT, ValueType.AUTO));
        map.put("le", new BiFieldFunction(BiOperationFabric.LE, ValueType.AUTO));
        map.put("gt", new BiFieldFunction(BiOperationFabric.GT, ValueType.AUTO));
        map.put("ge", new BiFieldFunction(BiOperationFabric.GE, ValueType.AUTO));
        map.put("eq", new BiFieldFunction(BiOperationFabric.EQ, ValueType.AUTO));
        map.put("or", new OrFunction());
        map.put("and", new AndFunction());
        map.put("if", new IfFieldFunction());
        map.put("xor", new XorFunction());
        map.put("not", new NotFunction());
        map.put("concat", new ConcatFunction());
        map.put("default", new DefaultFunction());
        map.put("normalize_ip", NormalizeIpFunctionConstructor.INSTANCE);
        return map;
    }

    // CSOFF: ParameterNumber
    public static FieldFunction create(
        final String functionName,
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        FunctionConstructor constructor = functions.get(functionName);
        if (constructor == null) {
            throw new FieldFunctionException(
                "Unknown function name: " + functionName);
        }
        return constructor.construct(fieldName, args, conditions);
    }
}
