package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class GetFunction implements FieldFunction, FunctionConstructor {
    private final FieldFunction fieldName;

    public GetFunction() {
        fieldName = null;
    }

    public GetFunction(final FieldFunction fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        return accessor.getFieldValue(
            fieldName.value(accessor, condAccessor).stringValue());
    }

    @Override
    public final FieldFunction construct(
        final String fielName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != 1) {
            throw new FieldFunctionException(
                "GetFunction: invalid argument count <"
                + args.size() + ">, but should be 1");
        }
        return new GetFunction(args.get(0));
    }

    @Override
    public String toString() {
        return "GetFunction( " + fieldName + ')';
    }
}
