package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class IfFieldFunction implements FieldFunction, FunctionConstructor {
    private final List<FieldFunction> args;

    public IfFieldFunction() {
        args = null;
    }

    public IfFieldFunction(final List<FieldFunction> args) {
        this.args = args;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        long value =
            args.get(0).value(accessor, condAccessor).intValue();

        if (value > 0) {
            return args.get(1).value(accessor, condAccessor);
        } else {
            return args.get(2).value(accessor, condAccessor);
        }
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() < 3) {
            throw new FieldFunctionException(
                "IfFunction: invalid argument count <"
                    + args.size() + ">, but should be 3");
        }
        return new IfFieldFunction(args);
    }

    @Override
    public String toString() {
        return "IfFunction( " + args + ')';
    }
}
