package ru.yandex.search.json.fieldfunction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.BooleanValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class MapContainsAnyFunction
    implements FieldFunction, FunctionConstructor
{
    private final List<FieldFunction> args;

    public MapContainsAnyFunction() {
        this.args = null;
    }

    public MapContainsAnyFunction(final List<FieldFunction> args) {
        this.args = args;
    }

    @Override
    public FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        Map<String, Long> map = new HashMap<>();
        SumMapFunction.addToMap(
            map,
            args.get(0).value(accessor, condAccessor).stringValue());

        boolean found = false;
        for (int i = 1; i < args.size(); i++) {
            found = map.containsKey(
                args.get(i).value(accessor, condAccessor).stringValue());
            if (found) {
                break;
            }
        }

        return BooleanValue.valueOf(found);
    }

    @Override
    public FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() < 2) {
            throw new FieldFunctionException(
                "SumMapFunction: invalid argument count <"
                    + args.size() + ">, but should be 2 or more");
        }

        return new MapContainsAnyFunction(args);
    }
}
