package ru.yandex.search.json.fieldfunction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.IntValue;

public class MapGetFunction
    implements FieldFunction, FunctionConstructor
{
    private final List<FieldFunction> args;

    public MapGetFunction() {
        this.args = null;
    }

    public MapGetFunction(final List<FieldFunction> args) {
        this.args = args;
    }

    @Override
    public FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        String mapStr = args.get(0).value(accessor, condAccessor).stringValue();
        Map<String, Long> map = new HashMap<>();
        SumMapFunction.addToMap(map, mapStr);
        Long value =
            map.get(
                args.get(1).value(accessor, condAccessor).stringValue());
        if (value == null) {
            value = 0L;
        }
        return new IntValue(value);
    }

    @Override
    public FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != 2) {
            throw new FieldFunctionException(
                "MapGetFunction: invalid argument count <"
                    + args.size() + ">, but should be 2 (map_field, key)");
        }

        return new MapGetFunction(args);
    }
}
